/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.schedual.service.impl;

import com.geoway.onemap.core.domain.system.SimpleRole;
import com.geoway.onemap.core.domain.system.SysUser;
import com.geoway.onemap.core.support.HttpConnectionUtil;
import com.geoway.onemap.zbph.constant.base.ConfigConstant;
import com.geoway.onemap.zbph.constant.base.XmxxType;
import com.geoway.onemap.zbph.domain.base.ProcessStep;
import com.geoway.onemap.zbph.domain.xfsbcgdlx.XfsbcgdLxXmxx;
import com.geoway.onemap.zbph.domain.xfsbcgdys.XfsbcgdYsXmxx;
import com.geoway.onemap.zbph.service.base.ProcessInstanceService;
import com.geoway.onemap.zbph.service.xfsbcgdlx.XfsbcgdLxXmxxService;
import com.geoway.onemap.zbph.service.xfsbcgdys.XfsbcgdYsXmxxService;
import com.geoway.zhgd.dao.IBaseFileDao;
import com.geoway.zhgd.dao.OutCheckGtyDao;
import com.geoway.zhgd.domain.OutCheckGty;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstracGtyVerifyServiceImpl {
    private Logger logger = Logger.getLogger(AbstracGtyVerifyServiceImpl.class);
    @Value(value="${project.uploadDir}")
    private String uploadDir;
    @Value(value="${scheduler.outcheckgty.state}")
    private String outcheckgtyState;
    @Autowired
    protected OutCheckGtyDao outCheckGtyDao;
    @Autowired
    protected XfsbcgdLxXmxxService lxXmxxService;
    @Autowired
    protected XfsbcgdYsXmxxService ysXmxxService;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    private IBaseFileDao baseFileDao;

    protected void startVerify() {
        if (!"true".equals(this.outcheckgtyState)) {
            return;
        }
        List outCheckGties = this.outCheckGtyDao.findByState(Integer.valueOf(1));
        if (outCheckGties.size() == 0) {
            return;
        }
        Map<String, List<OutCheckGty>> gtyGroup = outCheckGties.stream().collect(Collectors.groupingBy(OutCheckGty::getImportId));
        for (String importId : gtyGroup.keySet()) {
            this.manageInfo(importId, gtyGroup.get(importId));
        }
        Map<String, List<OutCheckGty>> projectGroup = outCheckGties.stream().collect(Collectors.groupingBy(OutCheckGty::getProjectId));
        for (String projectId : projectGroup.keySet()) {
            try {
                List<OutCheckGty> gtyList = projectGroup.get(projectId);
                Boolean complete = this.isComplete(gtyList);
                if (!complete.booleanValue()) continue;
                this.doFlow(gtyList.get(0).getXmjd(), gtyList.get(0).getProjectId());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)("\u5916\u4e1a\u6838\u67e5\u6d41\u7a0b\u53d8\u66f4\u5931\u8d25\uff1a" + e.getMessage()));
            }
        }
    }

    protected String downloadFj(String downloadPath, String type, String dkId, String fileName, Map<String, String> headers) throws Exception {
        String savePath = ConfigConstant.FileConfig.uploadDir + "fruit" + File.separator + type + File.separator + dkId;
        new File(savePath).mkdirs();
        HttpConnectionUtil.downLoadFromUrl((String)downloadPath, (String)fileName, (String)savePath, headers);
        return savePath;
    }

    private void doFlow(String code, String pid) {
        if (code.equals(XmxxType.LX.gtyType) || code.equals(XmxxType.LX.type)) {
            XfsbcgdLxXmxx xmxx = (XfsbcgdLxXmxx)this.lxXmxxService.findById(pid);
            SysUser user = this.getUser(xmxx.getXzqdm(), "\u5916\u4e1a\u6838\u67e5-\u7cfb\u7edf", xmxx.getProcessId());
            this.lxXmxxService.pass(Arrays.asList(pid.split(",")), user, "\u5b8c\u6210\u5916\u4e1a\u6838\u67e5", "", "", null);
            xmxx = (XfsbcgdLxXmxx)this.lxXmxxService.findById(pid);
            xmxx.setIswy(Double.valueOf(1.0));
            this.lxXmxxService.saveOrUpdate((Object)xmxx, null);
        } else {
            XfsbcgdYsXmxx xmxx = (XfsbcgdYsXmxx)this.ysXmxxService.findById(pid);
            SysUser user = this.getUser(xmxx.getXzqdm(), "\u5916\u4e1a\u6838\u67e5-\u7cfb\u7edf", xmxx.getProcessId());
            this.ysXmxxService.pass(Arrays.asList(pid.split(",")), user, "\u5b8c\u6210\u5916\u4e1a\u6838\u67e5", "", "", null);
            xmxx = (XfsbcgdYsXmxx)this.ysXmxxService.findById(pid);
            xmxx.setIswy(Double.valueOf(1.0));
            this.ysXmxxService.saveOrUpdate((Object)xmxx, null);
        }
    }

    private SysUser getUser(String xzqdm, String name, String processId) {
        ProcessStep processStep = this.processInstanceService.getCurrentStep(processId);
        SysUser sysUser = new SysUser();
        sysUser.setAlisname(name);
        sysUser.setUsername(name);
        sysUser.setXzqdm(xzqdm);
        sysUser.setId(name);
        HashSet<SimpleRole> roles = new HashSet<SimpleRole>();
        SimpleRole simpleRole = new SimpleRole();
        simpleRole.setRolename((String)processStep.getRelatedRoles().get(0));
        roles.add(simpleRole);
        sysUser.setRoles(roles);
        return sysUser;
    }

    public abstract void manageInfo(String var1, List<OutCheckGty> var2);

    public abstract Boolean isComplete(List<OutCheckGty> var1);
}

