package com.gw.base;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import com.gw.base.bean.GwBeanException;
import com.gw.base.bean.GiBeanFactory;
import com.gw.base.bean.GwBeanDefinitionStoreException;
import com.gw.base.bean.GwBeanHelper;
import com.gw.base.bean.GwNoSuchBeanException;
import com.gw.base.cache.GiCache;
import com.gw.base.cache.GiCacheManager;
import com.gw.base.cache.GiTtlCache;
import com.gw.base.cache.GwCacheManager;
import com.gw.base.convert.GiBeanMapper;
import com.gw.base.env.GiEnvironmenter;
import com.gw.base.env.GwEnvironmentHelper;
import com.gw.base.env.property.GwPropertyHelper;
import com.gw.base.json.GwJSON;
import com.gw.base.env.property.GiPropertier;
import com.gw.base.tool.GkConsole;
import com.gw.base.tool.GkConsoleTable;
import com.gw.base.lang.caller.GkCallerUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.data.page.support.GwPageConfig;

/**
 * 基础开发库</br>
 * 
 * Ga* annotation 注解</br>
 * Gi* interface 接口</br>
 * Gw* 实现类</br>
 * Gutil* util 工具类</br>
 * Gfun*  function 函数接口</br>
 * Gk* kit 内建工具类</br>
 * 
 * @author Ray
 *
 */

public abstract class Gw {
	
	
	/**
	 * 属性对象，获取配置属性
	 */
	public static final GiPropertier property = new GiPropertier() {

		@Override
		public boolean containsProperty(String key) {
			return GwPropertyHelper.getPropertier().containsProperty(key);
		}

		@Override
		public String getProperty(String key) {
			
			return GwPropertyHelper.getPropertier().getProperty(key);
		}

		@Override
		public String getProperty(String key, String defaultValue) {
			
			return GwPropertyHelper.getPropertier().getProperty(key, defaultValue);
		}

		@Override
		public <T> T getProperty(String key, Class<T> targetType) {
			
			return GwPropertyHelper.getPropertier().getProperty(key, targetType);
		}

		@Override
		public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
			
			return GwPropertyHelper.getPropertier().getProperty(key, targetType, defaultValue);
		}

		@Override
		public String getRequiredProperty(String key) throws IllegalStateException {
			
			return GwPropertyHelper.getPropertier().getRequiredProperty(key);
		}

		@Override
		public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
			
			return GwPropertyHelper.getPropertier().getRequiredProperty(key, targetType);
		}

		@Override
		public String resolvePlaceholders(String text) {
			
			return GwPropertyHelper.getPropertier().resolvePlaceholders(text);
		}

		@Override
		public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
			
			return GwPropertyHelper.getPropertier().resolvePlaceholders(text);
		}
	};
	
	/**
	 * 环境对象，获取环境值
	 */
	public static final GiEnvironmenter env = new GiEnvironmenter() {

		@Override
		public String[] getActiveProfiles() {
			
			return GwEnvironmentHelper.getEnvironmenter().getActiveProfiles();
		}

		@Override
		public String[] getDefaultProfiles() {
			
			return GwEnvironmentHelper.getEnvironmenter().getDefaultProfiles();
		}

		@Override
		public boolean isDev() {
			
			return GwEnvironmentHelper.getEnvironmenter().isDev();
		}

		@Override
		public boolean isDebugger() {
			
			return GwEnvironmentHelper.getEnvironmenter().isDebugger();
		}
	};
	
	/**
	 * 日志对象，日志工具
	 */
	public static final GiLoger log = new GiLoger() {

		@Override
		public boolean isFatalEnabled() {
			return GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).isFatalEnabled();
		}

		@Override
		public boolean isErrorEnabled() {
			
			return GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).isErrorEnabled();
		}

		@Override
		public boolean isWarnEnabled() {
			
			return GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).isWarnEnabled();
		}

		@Override
		public boolean isInfoEnabled() {
			
			return GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).isInfoEnabled();
		}

		@Override
		public boolean isDebugEnabled() {
			
			return GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).isDebugEnabled();
		}

		@Override
		public boolean isTraceEnabled() {
			
			return GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).isTraceEnabled();
		}

		@Override
		public void fatal(String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).fatal(format, arguments);
		}

		@Override
		public void fatal(Throwable t) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).fatal(t);
			
		}

		@Override
		public void fatal(Throwable t, String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).fatal(t, format, arguments);
		}

		@Override
		public void error(String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).error(format, arguments);
		}

		@Override
		public void error(Throwable t) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).error(t);
		}

		@Override
		public void error(Throwable t, String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).error(t, format, arguments);
		}

		@Override
		public void warn(String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).warn(format, arguments);
		}

		@Override
		public void warn(Throwable t) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).warn(t);
		}

		@Override
		public void warn(Throwable t, String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).warn(t, format, arguments);
		}

		@Override
		public void info(String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).info(format, arguments);
		}

		@Override
		public void info(Throwable t) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).info(t);
		}

		@Override
		public void info(Throwable t, String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).info(t, format, arguments);
		}

		@Override
		public void debug(String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).debug(format, arguments);
		}

		@Override
		public void debug(Throwable t) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).debug(t);
		}

		@Override
		public void debug(Throwable t, String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).debug(t, format, arguments);
		}

		@Override
		public void trace(String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).trace(format, arguments);
		}

		@Override
		public void trace(Throwable t) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).trace(t);
		}

		@Override
		public void trace(Throwable t, String format, Object... arguments) {
			GwLoger.getLoger(GkCallerUtil.getCallerCallerName()).trace(t, format, arguments);
		}

		
	};
	
	/**
	 *  Bean 容器对象
	 */
	public static final GiBeanFactory beans = new GiBeanFactory() {

		@Override
		public Object getBean(String name) throws GwBeanException {
			return GwBeanHelper.getProvider().getBean(name);
		}

		@Override
		public <T> T getBean(String name, Class<T> requiredType) throws GwBeanException {
			
			return GwBeanHelper.getProvider().getBean(name,requiredType);
		}

		@Override
		public Object getBean(String name, Object... args) throws GwBeanException {
			
			return GwBeanHelper.getProvider().getBean(name, args);
		}

		@Override
		public <T> T getBean(Class<T> requiredType, Object... args) throws GwBeanException {
			
			return GwBeanHelper.getProvider().getBean(requiredType, args);
		}

		@Override
		public <T> T getBean(Class<T> requiredType) throws GwBeanException {
			
			return GwBeanHelper.getProvider().getBean(requiredType);
		}

		@Override
		public <T> T getBean(Class<T> requiredType, Type[] genericType) throws GwBeanException {
			
			return GwBeanHelper.getProvider().getBean(requiredType, genericType);
		}

		@Override
		public <T> Map<String, T> getBeans(Class<T> clazz, Type[] genericType) throws GwBeanException {
			
			return GwBeanHelper.getProvider().getBeans(clazz, genericType);
		}

		@Override
		public <T> Map<String, T> getBeans(Class<T> clazz) throws GwBeanException {
			
			return GwBeanHelper.getProvider().getBeans(clazz);
		}

		@Override
		public boolean containsBean(String name) {
			
			return GwBeanHelper.getProvider().containsBean(name);
		}

		@Override
		public boolean isSingleton(String name) throws GwNoSuchBeanException {
			
			return GwBeanHelper.getProvider().isSingleton(name);
		}

		@Override
		public boolean isPrototype(String name) throws GwNoSuchBeanException {
			
			return GwBeanHelper.getProvider().isPrototype(name);
		}

		@Override
		public boolean isTypeMatch(String name, Class<?> typeToMatch) throws GwNoSuchBeanException {
			
			return GwBeanHelper.getProvider().isTypeMatch(name, typeToMatch);
		}

		@Override
		public Class<?> getType(String name) throws GwNoSuchBeanException {
			
			return GwBeanHelper.getProvider().getType(name);
		}

		@Override
		public String[] getAliases(String name) {
			
			return GwBeanHelper.getProvider().getAliases(name);
		}

		@Override
		public void register(String name, Class<?> beanClass) throws GwBeanDefinitionStoreException {
			
			GwBeanHelper.getProvider().register(name, beanClass);
		}

		@Override
		public void register(String name, Class<?> beanClass, boolean singleton) throws GwBeanDefinitionStoreException {
			
			GwBeanHelper.getProvider().register(name, beanClass, singleton);
		}
		
	};

	/**
	 * bean映射器
	 */
	public static GiBeanMapper<Object,Object> beanMapper = new GiBeanMapper<Object,Object>(){
		@Override
		public void mapping(Object source, Object target) {
			GiBeanMapper.mapper(source,target);
		}
	};

	/**
	 * bean映射器
	 */
	public static GiCacheManager cache = new GiCacheManager(){
		@Override
		public GiCache getCache(String name) {
			return GwCacheManager.getCacheManager().getCache(name);
		}

		@Override
		public Collection<String> getCacheNames() {
			return GwCacheManager.getCacheManager().getCacheNames();
		}
	};


	/**
	 * bean映射器
	 */
	public static GiTtlCache ttlCache = new GiTtlCache() {
		@Override
		public void put(Object key, Object value, long millisecondsTtl) {
			GwCacheManager.getTtlCache().put(key,value,millisecondsTtl);
		}

		@Override
		public long pttl(Object key) {
			return GwCacheManager.getTtlCache().pttl(key);
		}

		@Override
		public String getName() {
			return GwCacheManager.getTtlCache().getName();
		}

		@Override
		public Object getNativeCache() {
			return GwCacheManager.getTtlCache().getNativeCache();
		}

		@Override
		public void put(Object key, Object value) {
			GwCacheManager.getTtlCache().put(key,value);
		}

		@Override
		public Object putIfAbsent(Object key, Object value) {
			return GwCacheManager.getTtlCache().putIfAbsent(key,value);
		}

		@Override
		public Object getObject(Object key) {
			return GwCacheManager.getTtlCache().getObject(key);
		}

		@Override
		public <T> T get(Object key, Class<T> type) {
			return GwCacheManager.getTtlCache().get(key,type);
		}

		@Override
		public <T> T get(Object key, Callable<T> valueLoader) {
			return GwCacheManager.getTtlCache().get(key,valueLoader);
		}

		@Override
		public void evict(Object key) {
			GwCacheManager.getTtlCache().evict(key);
		}

		@Override
		public void clear() {
			GwCacheManager.getTtlCache().clear();
		}
	};
	
	public static void print(Object obj,Object... otherObjs) {
		GkConsole.print(obj, otherObjs);
	}
	public static void println(Object obj,Object... otherObjs) {
		GkConsole.log(obj, otherObjs);
	}
	
	
	public static void printTable(String... values) {
		GkConsoleTable.create().addHeader(values).addBody(values).print();
	}
	
	public static GwJSON toJson(Object json) {
		return GwJSON.toJson(json);
	}
}
