package com.gw.base.active;

import com.gw.base.exception.GwException;
import com.gw.base.lang.invoke.GaMethodHandDefine;
import com.gw.base.lang.invoke.GkMethodHand;
import com.gw.base.active.support.GwThreadLocalActiver;

public interface GiActiver<U extends GiActivable>{

	public U active();
	
	public void active(U act);
	
	public void deactive(U act);
	
	@GaMethodHandDefine(expectClassName = "com.gw.web.active.GwWebActiver",expectMethodName="getActiver")
	public static <T extends GiActivable> GiActiver<T> getActiver(Class<T> userClass) {
		return (GiActiver<T>)GkMethodHand.invokeSelf(userClass);
	}
	
	public static <T extends GiActivable> T getActive(Class<T> userClass) {
		GiActiver<T> activer = GiActiver.getActiver(userClass);
		T act = activer.active();
		if(act != null) {
			if(!userClass.isInstance(act)) {
				throw new GwException("GiActiver获取错误的类型,实际的类型是:{},参数类型是:{}",act.getClass().getName(),userClass.getName());
			}
			return act;
		}
		return null;
    }
	
}
