package com.gw.base.active.support;

import com.gw.base.active.GiActivable;
import com.gw.base.active.GiActiver;
import com.gw.base.lang.invoke.GaMethodHandImpl;
import com.gw.base.lang.invoke.GaMethodHandImpl.ImplType;
import com.gw.base.lang.invoke.GkMethodHand;

import java.util.concurrent.ConcurrentHashMap;

public class GwThreadLocalActiver<U extends GiActivable> implements GiActiver<U> {

	static {
		GkMethodHand.implFromClass(GwThreadLocalActiver.class);
	}

	public static ConcurrentHashMap<Class<?>,GiActiver<?>> threadLocalActivers = new ConcurrentHashMap<>();

	@GaMethodHandImpl(implClass = GiActiver.class,implMethod="getActiver",type=ImplType.comity)
	private static <U extends GiActivable> GiActiver<U> getActiver(Class<U> userClass) {

		if(threadLocalActivers.containsKey(userClass)) {
			return (GiActiver<U>)threadLocalActivers.get(userClass);
		}
		return new GwThreadLocalActiver(userClass);
	}


	private GwThreadLocalActiver(Class<U> userClass) {
		threadLocalActivers.put(userClass, this);
	}
	
	
	private ThreadLocal<U> current = new ThreadLocal<U>();

	@Override
	public U active() {
		return current.get();
	}

	@Override
	public void active(U user) {
		current.set(user);
	}

	@Override
	public void deactive(U user) {
		current.remove();
	}


	


}
