package com.gw.base.aop.support;

import com.gw.base.aop.GiProxyAspect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

/**
 * @Author Ray
 */
public class GwProxyAspectInvocationHandler implements InvocationHandler {

    private GiProxyAspect proxyAspect;

    public GwProxyAspectInvocationHandler(){
    }

    public GwProxyAspectInvocationHandler(GiProxyAspect giProxyAspect){
        proxyAspect = giProxyAspect;
    }


    public Object invokeAspect(Object proxy, Method method, Object[] args) throws Throwable {

        boolean boo = proxyAspect.before( proxy, method,args);
        if(boo){
            Object res = null;
            try {
                //res = method.invoke(this, args);
            }catch (Exception e){
                boo = proxyAspect.afterException( proxy, method,args,e);
                if(boo){
                    return null;
                }
            }
            boo = proxyAspect.after( proxy, method,args,res);
            if(boo){
                return res;
            }
        }
        return null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if(proxyAspect == null){
           //return method.invoke(this, args);
        }
        return invokeAspect(proxy,method,args);
    }
}
