package com.gw.base.api.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.gw.base.data.page.GiPager;
import com.gw.base.def.annotation.GaParameter;


@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
public @interface GaApiAction {
public static final String NULL = "";

    /**
     * 名称唯一键
     * @return
     */
	public String name() default NULL;

    /**
     * 文本标题
     * @return
     */
	public String text() default NULL;

    /**
     * 别名
     * @return
     */
    public String alias() default NULL;

    /**
     * 发布说明
     * @return
     */
    public String notes() default NULL;

    /**
     * 标签分组
     * @return
     */
    public String[] tags() default "";

    /**
     * 是否隐藏
     * @return
     */
    boolean hidden() default false;

    /**
     * 返回结果集类型
     * @return
     */
    Class<?> response() default Void.class;

    /**
     * 分页对象类型
     * @return
     */
    Class<? extends GiPager> pager() default GiPager.class;

    /**
     * 是否开启验证 默认开启
     * @return
     */
    public boolean captcha() default true;

    /**
     * 锁定持续时长 单位毫秒 0为永久
     * @return
     */
    public long captchaDuration() default 0L;

    /**
     * captcha 触发验证最大可执行次数 默认调用1次触发， 设置0每次都触发,可在头部传递解锁信息
     * @return
     */
    public long captchaLimit() default 1L;

    /**
     * 验证最大可执行次数的时长 默认0 不做限制，设置一个时间间隔在这个间隔时间内如果不累加，计数器清0
     * @return
     */
    public long captchaLimitDuration() default 0L;

    /**
     * 是否开启审计记录 默认开启
     * @return
     */
    public boolean audit() default true;

    /**
     * 参数
     * @return
     */
    public GaParameter[] cfg() default {};
}


	
