package com.gw.base.atomic;


import com.gw.base.atomic.support.GwLongAdder;
import com.gw.base.sp.GkSP;
import com.gw.base.sp.GwSpHelper;

@GkSP(placeHolderClass = GwLongAdder.class,singleton = false)
public interface GiLongAdder {


    public void add(long x);
    /**
     * Equivalent to {@code add(1)}.
     */
    public void increment();

    /**
     * Equivalent to {@code add(-1)}.
     */
    public void decrement();

    public long sum() ;

    public void reset();

    public long sumThenReset();


    public static GiLongAdder get(){
        return GwSpHelper.load(GiLongAdder.class);
    }

}
