package com.gw.base.atomic.support;

import com.gw.base.atomic.GiLongAdder;
import com.gw.base.atomic.GiLongAdderManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GwLongAdderManager implements GiLongAdderManager {


    private final ConcurrentMap<String, GiLongAdder> cacheMap = new ConcurrentHashMap<>(16);

    @Override
    public GiLongAdder get(String name) {
        //GwCacheManager.getTtlCache().putIfAbsent()

        return cacheMap.computeIfAbsent(name, k ->{
            return GiLongAdder.get();
        });
    }
}
