package com.gw.base.bean;

import com.gw.base.exception.GwException;
import com.gw.base.sp.GkSP;
import com.gw.base.sp.GwCacheSpLoader;

import java.lang.reflect.Type;

public class GwBeanFactorySpLoader extends GwCacheSpLoader {

	@Override
	public <T> T load(Class<T> cls,Type[] types) {
		
		GkSP spiAn = cls.getAnnotation(GkSP.class);
    	if(spiAn == null) {
    		throw new GwException("获取sp实现的接口必须包含GkSP注解：{} ",cls.getName());
    	}
    	T t = null;
		if(spiAn.singleton()) {
			t = super.load(cls, types);
		}
		if(t == null) {
			if(GwBeanHelper.getProvider() != null) {
				try {
					if(types.length > 0) {
						t = GwBeanHelper.getProvider().getBean(cls, types);
					}else {
						t = GwBeanHelper.getProvider().getBean(cls);
					}
				}catch(GwNoUniqueBeanException nex) {
					throw nex;
				}catch(GwNoSuchBeanException nex) {
					//
				}
			}
		}
		if(spiAn.singleton() && t != null) {
			this.setCache(cls, types, t);
		}
		return t;
	}

}
