package com.gw.base.cache;

import java.util.concurrent.Callable;


/**
 * Cache 通用api，这里仿照spring cache而不是JSR是因为大部分缓存方案适配spring cache.
 * 简化spring cache的ValueWrapper
 * @author Ray
 *
 */
public interface GiCache {
	
	/**
	 * 获取缓存名称
	 * @return
	 */
	String getName();

	/**
	 * 获取实际的缓存器
	 * @return
	 */

	Object getNativeCache();
	/**
	 * 加入缓存
	 * @param key
	 * @param value
	 */
	void put(Object key, Object value);

	/**
	 * 如果不存在就放入。如果存在就返回已经存在的值
	 * @param key
	 * @param value
	 * @return
	 */
	Object putIfAbsent(Object key, Object value);
	/**
	 * 获取缓存
	 * @param key
	 * @return
	 */
	Object getObject(Object key);
	/**
	 * 获取缓存 返回对应类型
	 * @param <T>
	 * @param key
	 * @param type
	 * @return
	 */
	<T> T get(Object key, Class<T> type);
	/**
	 *  返回常用字符串缓存
	 * @param key
	 * @return
	 */
	default String getString(Object key){
		return this.get(key,String.class);
	}
	/**
	 *  获取缓存 返回对应类型
	 * @param <T>
	 * @param key
	 * @param valueLoader
	 * @return
	 */
	<T> T get(Object key, Callable<T> valueLoader);
	/**
	 * 清除掉某个key的缓存
	 * @param key
	 */
	void evict(Object key);
	/**
	 *  清空缓存
	 * @return
	 */
	void clear();
	
}

/*
 * spring cache
 
public interface Cache {
	String getName();
	// 返回本地存储的那个。比如ConcurrentMapCache本地就是用的一个ConcurrentMap
	Object getNativeCache();
	
	// 就是用下面的ValueWrapper把值包装了一下而已~

	ValueWrapper get(Object key);

	<T> T get(Object key,  Class<T> type);

	<T> T get(Object key, Callable<T> valueLoader);
	
	void put(Object key,  Object value);
	// @since 4.1
	// 不存在旧值直接put就先去了返回null，否则返回旧值（并且不会把新值put进去）

	ValueWrapper putIfAbsent(Object key,  Object value);
	// 删除
	void evict(Object key);
	// 清空
	void clear();


	@FunctionalInterface
	interface ValueWrapper {

		Object get();
	}
}

*/