package com.gw.base.cache;

/**
 * 有剩余时间的缓存
 */
public interface GiTtlCache extends GiCache{

    /**
     * 放入缓存
     * @param key
     * @param value
     * @param millisecondsTtl 有效期 单位:毫秒 milliseconds 如果设置0 等于删除，设置 负数 =永久
     */
    void put(Object key, Object value,long millisecondsTtl);

    /**
     * 获取返回剩余时间 以毫秒为单位获取key的剩余时间，没有设置时间返回 -1,不存在键 返回0
     * @param key
     * @return 剩余时间 单位:毫秒 milliseconds
     */
    long pttl(Object key);

}
