package com.gw.base.cache;

import com.gw.base.cache.support.GwTtlMapCache;
import com.gw.base.lang.invoke.GkMethodHand;
import com.gw.base.cache.support.GwMemoryCacheManager;
import com.gw.base.lang.invoke.GaMethodHandDefine;
import com.gw.base.lang.invoke.GaMethodHandImpl;
import com.gw.base.lang.invoke.GaMethodHandImpl.ImplType;


/**
 * 缓存操作工具。如果要使用缓存注解，推荐使用JSR107定义的注解。
 * 
 * @author Ray
 *
 *  JSR107 定义注解
 *
 * (@CacheResult)将指定的key和value映射内容存入到缓存容器中
 * (@CachePut)	更新指定缓存容器中指定key值缓存记录内容
 * (@CacheRemove)	移除指定缓存容器中指定key值对应的缓存记录
 * (@CacheRemoveAll)	字面含义，移除指定缓存容器中的所有缓存记录
 * (@CacheKey)	作为接口参数前面修饰，用于指定特定的入参作为缓存key值的组成部分
 * (@CacheValue)	作为接口参数前面的修饰，用于指定特定的入参作为缓存value值
 *
 *  * JSR107 Api用法
 * CachingProvider：创建、配置、获取、管理和控制多个CacheManager
 * CacheManager：创建、配置、获取、管理和控制多个唯一命名的Cache。（一个CacheManager仅被一个CachingProvider所拥有）
 * Cache：一个类似Map的数据结构。（一个Cache仅被一个CacheManager所拥有）
 * Entry：一个存储在Cache中的key-value对
 * Expiry：每一个存储在Cache中的条目有一个定义的有效期，过期后不可访问、更新、删除。缓存有效期可以通过ExpiryPolicy设置
 */

public class GwCacheManager{
	
	private GwCacheManager() {}
	
	
	static {
		GkMethodHand.implFromClass(GwCacheManager.class);
	}
	
	/**
	 * 获取cacheManager对象
	 */
	@GaMethodHandDefine()
	public static GiCacheManager getCacheManager() {
		return (GiCacheManager)GkMethodHand.invokeSelf();
	}
	
	
	private static GwMemoryCacheManager memoryCacheManager = new GwMemoryCacheManager();
	/**
	 * 默认实现，提供一个内存的动态缓存管理器管理的缓存
	 */
	@GaMethodHandImpl(implClass=GwCacheManager.class,implMethod="getCacheManager",type=ImplType.comity)
	private static GiCacheManager _getCacheManager() {
		return memoryCacheManager;
	}


	/**
	 * 获取ttlCache对象
	 */
	@GaMethodHandDefine()
	public static GiTtlCache getTtlCache() {
		return (GiTtlCache)GkMethodHand.invokeSelf();
	}


	private static GiTtlCache gwTtlMapCache = new GwTtlMapCache();
	/**
	 * 默认实现，提供一个内存的Ttl缓存
	 */
	@GaMethodHandImpl(implClass=GwCacheManager.class,implMethod="getTtlCache",type=ImplType.comity)
	private static GiTtlCache _getTtlCache() {
		return gwTtlMapCache;
	}
	
	
}
