package com.gw.base.cache.support;

import java.util.concurrent.Callable;

import com.gw.base.cache.GiCache;
import com.gw.base.cache.GiTtlCache;

public class GwTtlMapCache implements GiTtlCache {
	
	protected static GwTtlMap<Object,Object> cacheMap = new GwTtlMap<Object,Object>();
	
	private String name;
	
	public GwTtlMapCache() {
		name = this.getClass().getName();
	}
	
	public GwTtlMapCache(String name) {
		this.name = name;
	}
	
	@Override
	public String getName() {
		return name;
	}

	@Override
	public Object getNativeCache() {
		return cacheMap;
	}

	@Override
	public String getString(Object key) {
		return (String)cacheMap.get(key);
	}

	@Override
	public Object getObject(Object key) {
		return cacheMap.get(key);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T get(Object key, Class<T> type) {
		return (T)cacheMap.get(key);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T get(Object key, Callable<T> valueLoader) {
		return (T)cacheMap.get(key);
	}

	@Override
	public void put(Object key, Object value) {
		put(key, value,-1);
	}

	@Override
	public Object putIfAbsent(Object key, Object value) {
		if(cacheMap.containsKey(key)){
			return cacheMap.get(key);
		}
		put(key,value);
		return value;
	}

	@Override
	public void evict(Object key) {
		cacheMap.remove(key);
	}

	@Override
	public void clear() {
		cacheMap.clear();
	}

	@Override
	public void put(Object key, Object value, long ttl) {
		cacheMap.put(key,value,ttl);
	}

	@Override
	public long pttl(Object key) {
		return cacheMap.pttl(key);
	}
}