package com.gw.base.client;

import com.gw.base.active.GiActivable;
import com.gw.base.active.GiActiver;

import java.io.Serializable;

public interface GiClient<ID extends Serializable> extends Serializable{


	public static <T extends GiClient<?>> T getClient(Class<T> userClass) {

		T res = null;

		if(GiActivable.class.isAssignableFrom(userClass)){
			res = (T) GiActiver.getActive((Class<? extends GiActivable>)userClass);
		}
		return res;
	}

	
	ID clientId();
	
	/**
	 * 是否是测试客户端
	 * @return
	 */
    default boolean isTest() {
    	return false;
    }
}
