package com.gw.base.client.permission;


import com.gw.base.client.GiClient;
import com.gw.base.permission.GaPermission;
import com.gw.base.user.GwNoLoginException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public interface GiClientPermissionHandler<PC extends GiPermissionClient<?>>{

	public Class<PC> permissionClientType();
	
    default public boolean permissionHandle(Method method) throws Exception {

    	boolean needCheck = false;
    	Annotation[] as = method.getAnnotations();
    	
        for (Annotation an : as) {
        	if(an.annotationType() == GaPermission.class) {
        		needCheck  = true;
        		
        	}
    	}
        
        if(needCheck) {
        	GiPermissionClient<?> client = GiClient.getClient(permissionClientType());
        	
        	if(client == null) {
        		throw new GwNoLoginException("请先登录");
        	}else {
				client.permissions();
        	}
        }

        return true;
    }
 
}
