package com.gw.base.client.permission;

import com.gw.base.client.GiClient;
import com.gw.base.permission.GiPermission;
import com.gw.base.permission.GiPermissionable;
import com.gw.base.permission.support.GwPermissionKid;
import com.gw.base.util.GutilCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface GiPermissionClient<ID extends Serializable> extends GiClient<ID>,GiPermissionable {
	
	default public Class<? extends GiPermissionClient> permissionType(){
		return this.getClass();
	}
	
	@Override
	default public Collection<? extends GiPermission> permissions(){
		
		List<GwPermissionKid> res =  new ArrayList<>();
		Collection<? extends GiPermission> ps = GiClientPermissionProvider.getProvider(this.permissionType()).clientPermissions(this);
		if(!GutilCollection.isEmpty(ps)) {
			for(GiPermission item : ps) {
				res.add(new GwPermissionKid(item));
			}
		}
		return res;
	}

}
