package com.gw.base.convert;

import com.gw.base.bean.GwBeanFactorySpLoader;
import com.gw.base.sp.GwSpHelper;
import com.gw.base.sp.GkSP;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

@GkSP(loader = GwBeanFactorySpLoader.class)
@FunctionalInterface
public interface GiBeanMapper<S, T> {
	
	void mapping(S source,T target);

	/*
	default <R> List<T> mappingList(List<S> source, Supplier<T> supplier,
								BiConsumer<R, ? super T> accumulator,
								BiConsumer<R, R> combiner){

		return source.stream().collect(supplier,accumulator,combiner);

	}
	 */


	public static <S,T> GiBeanMapper<S, T> getMapper(Class<? extends S> sourceClass,Class<? extends S> targetClass) {
		return GwSpHelper.load(GiBeanMapper.class,sourceClass,targetClass);
	}

	public static void mapper(Object source,Object target) {
		Class<? extends Object>  sourceClass = source.getClass();
		Class<? extends Object>  targetClass = target.getClass();
		GiBeanMapper<Object,Object> mapper = GiBeanMapper.getMapper(sourceClass,targetClass);
		mapper.mapping(source,target);
	}
}