package com.gw.base.convert.util;


import com.gw.base.convert.GiConverter;
import com.gw.base.convert.GiConverterProvider;
import com.gw.base.convert.support.GwConverterImpl;
import com.gw.base.lang.invoke.GkMethodHand;
import com.gw.base.lang.invoke.GaMethodHandDefine;
import com.gw.base.lang.invoke.GaMethodHandImpl;
import com.gw.base.lang.invoke.GaMethodHandImpl.ImplType;

public class GwConvertHelper {
	
	static {
		GkMethodHand.implFromClass(GwConvertHelper.class);
	}
	
	@GaMethodHandDefine()
	public static GiConverterProvider getProvider() {
		return (GiConverterProvider)GkMethodHand.invokeSelf();
	}
	
	
	@GaMethodHandImpl(implClass=GwConvertHelper.class,implMethod="getProvider",type=ImplType.comity)
	private static GiConverterProvider _getProvider() {
		return new GwConverterImpl();
	}

	
	public static<S, T> T convert(S source,Class<T> targetClass){
		
        Class<S> sc = (Class<S>)source.getClass();
        
		GiConverter<S, T> converter = GwConvertHelper.getProvider().getConverter(sc, targetClass);
		return converter.convert(source);
	}
	
	
	
	
}
