package com.gw.base.data.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import com.gw.base.data.GiVisualValuable;
import com.gw.base.data.support.GwVisualValueKid;

public class GemUtil {

    public static List<?> extractEnum(Class<?> clz){
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> p;
        for (GiVisualValuable<?> obj: (GiVisualValuable[])clz.getEnumConstants()) {
            p = new HashMap<>();
            p.put("valueField", obj.value());
            p.put("displayField", obj.display());
            list.add(p);
        }
        return list;
    }
    
    
    /**
     * 枚举转换成模型
     * @param <T>
     * @param <K>
     * @param enumClz
     * @return
     */
	public static <T extends Enum<T> & GiVisualValuable<K>,K> List<GwVisualValueKid<K>> extractEnumVisualValueKid(Class<T> enumClz) {
        List<GwVisualValueKid<K>> list = new ArrayList<>();
        for (GiVisualValuable<K> obj: (GiVisualValuable<K>[])enumClz.getEnumConstants()) {
            list.add(new GwVisualValueKid<K>(obj.value(),obj.display()));
        }
        return list;
    }
    


    public static List<String> extractEnumValues(Class<?> clz){
        List<String> list = new ArrayList<>();
        for (GiVisualValuable<?> obj: (GiVisualValuable[])clz.getEnumConstants()) {
            list.add((String) obj.value());
        }
        return list;
    }

    public static <T> T[] getEnumValue(Class<?> clz, Object key, Class<T> tClass){
        for (GiVisualValuable<?> obj : (GiVisualValuable[]) clz.getEnumConstants()) {
            if (key.equals(obj.display())){
                try {
                    return (T[])obj.value();
                }catch (Exception ignore){ }
            }
        }
        return null;
    }


    public static String getEnumDisplay(Class<?> clz, Object key){
        for (GiVisualValuable<?> obj : (GiVisualValuable[]) clz.getEnumConstants()) {
            if (obj.value() instanceof Integer){
                if (key instanceof String){
                    try {
                        if (obj.value().equals(Integer.valueOf((String) key))) {
                            return obj.display();
                        }
                    }catch (Exception ignore){ }
                }
                if (key instanceof Integer){
                    if (obj.value().equals(key)) {
                        return obj.display();
                    }
                }
            }else {
                if (obj.value().equals(key)) {
                    return obj.display();
                }
            }
        }
        return "";
    }

    public static GiVisualValuable<?> getEnumClass(Class<?> clz, Object key){
        for (GiVisualValuable<?> obj : (GiVisualValuable[]) clz.getEnumConstants()) {
            if (obj.value() instanceof Integer){
                if (key instanceof String){
                    try {
                        if (obj.value().equals(Integer.valueOf((String) key))) {
                            return obj;
                        }
                    }catch (Exception ignore){

                    }
                }
                if (key instanceof Integer){
                    if (obj.value().equals(key)) {
                        return obj;
                    }
                }
            }else {
                if (obj.value().equals(key)) {
                    return obj;
                }
            }
        }
        return null;
    }
    
    
    public static <T extends Enum<T> & GiVisualValuable<K>,K> T valueOf(Class<T> enumType,K value,T defalutE) {
		T[] ts = enumType.getEnumConstants();
		for(T t :ts) {
			if (Objects.equals(t.value(),value)) {
				return t;
			}
		}
		return defalutE;
	}

}
