package com.gw.base.data.model;

import com.gw.base.data.GiType;
import com.gw.base.data.model.support.GwModelTypeKid;
import com.gw.base.util.GutilStr;

public interface GiModelType extends GiType{
	
	
	public <T extends GiTypeModelable> Class<T> gwTypeModelClass(Class<? super T> cls);
	
	
	default GwModelTypeKid toModelTypeKid() {
		
		if(GutilStr.isNotEmpty(this.gwTypeId())) {
			GwModelTypeKid kid = GwModelTypeKid.valueFor(this.gwTypeId());
			if(kid != null) {
				return kid;
			}
		}
		
		Class<? extends GiTypeModelable> typeModelClass = gwTypeModelClass(GiTypeModelable.class);
		if(typeModelClass != null) {
			return GwModelTypeKid.valueFor(typeModelClass);
		}
		
		return null;
	}
	
}
