package com.gw.base.data.model.support;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import com.gw.base.data.model.GiModelType;
import com.gw.base.data.model.GiTypeModelable;
import com.gw.base.data.model.annotation.GaModel;
import com.gw.base.data.support.GwTypeKid;
import com.gw.base.util.GutilDigest;
import com.gw.base.util.GutilObject;

public class GwModelTypeKid extends GwTypeKid implements GiModelType{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2085317997278008680L;

	@SuppressWarnings("rawtypes")
	private static final Map<Class<? extends GiTypeModelable>,GwModelTypeKid> typeModelTypes = new HashMap<>();
	
	public static <TM extends GiTypeModelable<ID>,ID extends Serializable> GwModelTypeKid valueFor(Class<TM> typeModelClass) {
		
		GwModelTypeKid ut = typeModelTypes.get(typeModelClass);
		if(ut == null) {
			GaModel an = typeModelClass.getAnnotation(GaModel.class);
			String modelTypeId = null;
			String modelTypeName = null;
			if(an != null) {
				if(!GutilObject.equal(GaModel.NULL, an.name())) {
					modelTypeId = an.name();
					if(!GutilObject.equal(GaModel.NULL, an.text())) {
						modelTypeName = an.text();
					}
				}
			}
			if(modelTypeId == null) {
				modelTypeId = GutilDigest.md5DigestAsHex((typeModelClass.getName()).getBytes());
			}
			if(modelTypeName == null) {
				modelTypeName = typeModelClass.getName();
			}
			ut = new GwModelTypeKid(typeModelClass,modelTypeId, modelTypeName);
			typeModelTypes.put(typeModelClass, ut);
		}
		
		return ut;
		
	}
	
	@SuppressWarnings("rawtypes")
	public static GwModelTypeKid valueFor(String modelTypeId) {
		if(typeModelTypes.size() > 0) {
			Iterator<Entry<Class<? extends GiTypeModelable>,GwModelTypeKid>> it = typeModelTypes.entrySet().iterator();
		    while(it.hasNext()){
		        Entry<Class<? extends GiTypeModelable>,GwModelTypeKid> entry = it.next();
		        if(GutilObject.equal(entry.getValue().getGwTypeId(), modelTypeId)) {
		        	return entry.getValue();
		        }
	        }
		}
		return null;
	}
	
	
	public GwModelTypeKid() {
		
	}
	
	
	public GwModelTypeKid(Class<? extends GiTypeModelable> typeModelClass,String gwTypeId,String gwTypeName) {
		super(gwTypeId,gwTypeName);
		this.gwTypeModelClass = typeModelClass;
		
	}
	
	private Class<? extends GiTypeModelable> gwTypeModelClass;


	public Class<? extends GiTypeModelable> getGwTypeModelClass() {
		return gwTypeModelClass;
	}

	public void setGwTypeModelClass(Class<? extends GiTypeModelable> gwTypeModelClass) {
		this.gwTypeModelClass = gwTypeModelClass;
	}

	@Override
	public <T extends GiTypeModelable> Class<T> gwTypeModelClass(Class<? super T> cls) {
		return (Class<T>)gwTypeModelClass;
	}


}
