package com.gw.base.data.model.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import com.gw.base.data.model.GiModelType;
import com.gw.base.data.model.GiTypeModelable;

@SuppressWarnings("serial")
public class GwTypeModelKid<ID extends Serializable> extends GwModelKid<ID> implements GiTypeModelable<ID> {

	
	GwModelTypeKid gwModelType;
	
	@Override
	public GiModelType gwModelType() {
		return gwModelType;
	}
	
	public GwTypeModelKid() {}
	
	public GwTypeModelKid(GwModelTypeKid gwModelTypeKid,ID id) {
		super(id);
		this.gwModelType = gwModelTypeKid;
	}
	
	
	public static <ID extends Serializable> GwTypeModelKid<ID> valueWith(GwModelTypeKid modelTypeKid,ID id) {
        return new GwTypeModelKid<ID>(modelTypeKid,id);
    }
	
	public static <ID extends Serializable> Collection<GwTypeModelKid<?>> valuesWith(GwModelTypeKid modelTypeKid,Set<ID> ids) {
		
		List<GwTypeModelKid<?>> list = new ArrayList<>();
		for(ID id : ids) {
			list.add(new GwTypeModelKid<ID>(modelTypeKid,id));
		}
		
        return list;
    }

	public GwModelTypeKid getGwModelType() {
		return gwModelType;
	}

	public void setGwModelType(GwModelTypeKid gwModelType) {
		this.gwModelType = gwModelType;
	}
	
}
