package com.gw.base.data.page;

import java.io.Serializable;
import java.lang.reflect.Type;
import com.gw.base.lang.lambda.GkfLambdaMeta;
import com.gw.base.util.GutilClass;
import com.gw.base.util.GutilGenericType;
import com.gw.base.util.GutilLambda;


/**
 * 分页执行函数接口
 * @author Ray
 * 
 **/
@FunctionalInterface
public interface GfunPageExcute<R> extends Serializable{
	
	Iterable<R> excute();
    
    
	/**
	 * 获取返回包装对象
	 * @return
	 */
    default GiPager<R> getGwPager(){
    	return GiPager.ofClass(this.getReturnClass());
    }
    
    /**
     * 获取返回类型
     * 这里对LAMBDA并不友好，执行器请使用实现类或匿名类的形式。
     * @return
     */
    @SuppressWarnings("unchecked")
	default Class<R> getReturnClass(){
    	
    	Class<?> myClass = this.getClass();
    	
    	if (myClass.getName().contains(GutilClass.LAMBDA_CLASS_SIGN)) {
    		GkfLambdaMeta lm = GutilLambda.extract(this);
    		myClass = lm.getInstantiatedClass();
    	}else {
    		myClass = GutilClass.getUserClass(this);
    	}
    	
    	if(GfunPageExcute.class.isAssignableFrom(myClass)) {
	    	Type[] types = GutilGenericType.resolveTypeArguments(myClass,GfunPageExcute.class);
	    	if(types != null && types.length > 0) {
	    		Type type = types[0];
	    		if(type instanceof Class) {
	    			return (Class<R>)type;
	    		}
	    	}
    	}
    	return null;
    }

    
}
