package com.gw.base.data.page;

import java.io.Serializable;
import com.gw.base.gpa.support.GwSort;
import com.gw.base.sp.GwSpHelper;

/**
 * 
 * 包装分页请求参数的接口
 * 
 * @author Ray
 *
 */

public interface GiPageParam extends Serializable {
	
	
	//每页的数量 limit
	public int pageSize();
	//游标开始行
	public long startRow();
	//当前页码
	public int pageNum();
	
	/**
     * 是否包含count查询
     */
    public boolean countTotal();
	//获取排序条件
	public GwSort sort();
	
	public GiPageParam putParam(Integer pageSize,Integer pageNum,Long startRow);
	
	public GiPageParam putSort(GwSort sort);
	
	public GiPageParam putCountTotal(boolean countTotal);
	
	
	/**
	 * 初始化一个GiPageParam对象。
	 */
	public static GiPageParam of() {
		return GwSpHelper.load(GiPageConfig.class).getPageParamProvider().getPageParam();
	}
	/**
	 * 初始化一个GiPageParam对象。
	 * @param pageSize
	 * @param pageNum
	 * @param startRow
	 * @return
	 */
	public static GiPageParam of(Integer pageSize,Integer pageNum,Long startRow) {
		return of().putParam(pageSize, pageNum, startRow);
	}
	
}
