package com.gw.base.data.page;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import com.gw.base.convert.GiConverter;
import com.gw.base.data.GiValuable;
import com.gw.base.sp.GwSpHelper;
import com.gw.base.util.GutilClass;
import com.gw.base.util.GutilGenericType;


/**
 * 分页结果集接口
 * @author Ray
 *
 * @param <T>
 */
public interface GiPager<T> extends GiValuable<Iterable<T>> {
	
	/**
	 * 总条数
	 * @return
	 */
	public long total();
	
	/**
	 * 查询条件
	 * @return
	 */
	public GiPageParam pageParam();
	
	public GiPager<T> put(Iterable<T> list,long total,GiPageParam pageParam);
	
	@SuppressWarnings("unchecked")
	default Class<T> returnClass(){
		return (Class<T>)GutilGenericType.resolveTypeArguments(GutilClass.getUserClass(this),GiPager.class)[0];
	}
	
	/**
	 * 转换成另外一个Pager对象，对结果集进行遍历转换
	 * @param <V>
	 * @param pager
	 * @param converter
	 * @return
	 */
	default <V,K extends GiPager<V>> K convert(K pager,GiConverter<T, V> converter) {
		Objects.requireNonNull(converter, "转换器不能为空");
		List<V> list = new ArrayList<>();
		Iterable<T> vs = this.value();
		if(vs != null) {
			vs.forEach(t -> {
				V v = converter.convert(t);
				list.add(v);
			});
		}
		pager.put(list, this.total(), this.pageParam());
		return pager;
	}
	
	/**
	 * 根据返回值类型获取一个GiPager包装类
	 * @param <T>
	 * @param clz
	 * @return
	 */
	public static <T> GiPager<T> ofClass(Class<T> clz){
		return GwSpHelper.load(GiPageConfig.class).getPagerProvider().getPager(clz);
	}
}
