package com.gw.base.data.page.support;

import com.gw.base.data.model.annotation.GaModel;
import com.gw.base.data.model.annotation.GaModelField;
import com.gw.base.data.page.GiPageParam;
import com.gw.base.data.page.GiPager;

@SuppressWarnings("serial")
@GaModel(text="分页")
public class GwPager<T> implements GiPager<T> {
	
	//@GaModelField(text="版本号")
	//protected String version = PRODUCT_VERSION;//版本号
	
	@GaModelField(text="总页数")
	private int pageSize = 0;//状态码
	
	@GaModelField(text="游标开始行")
	private long startRow = 0;
	
	@GaModelField(text="当前页码")
	private int pageNum = 0;

	@GaModelField(text="分页参数")
	private GwPageParam pageParam;
	
	@GaModelField(text="总条数")
	private long total = 0;//消息类型
	
	@GaModelField(text="业务数据")
	private Iterable<T> list;// 数据



	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public void setStartRow(long startRow) {
		this.startRow = startRow;
	}

	public void setPageNum(int pageNum) {
		this.pageNum = pageNum;
	}

	public void setPageParam(GwPageParam pageParam) {
		this.pageParam = pageParam;
	}

	public void setTotal(long total) {
		this.total = total;
	}

	public void setList(Iterable<T> list) {
		this.list = list;
	}

	public Class<T> getTypeClass() {
		return typeClass;
	}

	//
	public GwPager() {
	}
	
	private Class<T> typeClass;
	
	public GwPager(Class<T> cls) {
		typeClass = cls;
	}
	
	@Override
	public Class<T> returnClass(){
		return typeClass;
	}
	
	
	public int getPageSize() {
		return pageSize;
	}
	@Override
	public long total() {
		return total;
	}
	@Override
	public Iterable<T> value() {
		return list;
	}
	@Override
	public GwPager<T> put(Iterable<T> list,long total,GiPageParam pageParam) {
		this.list = list;
		this.total = total;
		this.pageParam = new GwPageParam().putParam(pageParam);
		this.pageNum = pageParam.pageNum();
		this.startRow = pageParam.startRow();
		this.pageSize = pageParam.pageSize();
		
		return this;
	}
	
	public GwPageParam getPageParam() {
		return pageParam;
	}

	public long getTotal() {
		return total;
	}

	public long getStartRow() {
		return startRow;
	}
	
	
	public int getPageNum() {
		return pageNum;
	}
	
	public Iterable<T> getList() {
		return list;
	}

	@Override
	public GwPageParam pageParam() {
		return pageParam;
	}
}
