package com.gw.base.data.result;

import com.gw.base.data.GiValuable;
import com.gw.base.sp.GwSpHelper;

/**
 *  数据结果集
 * @author Ray
 *
 * @param <T> 实际数据类型
 */
public interface GiResult<T> extends GiValuable<T> {
	
	/**
	 * 获取状态码
	 * @return
	 */
	public int code();
	/**
	 * 设置状态码
	 * @param code
	 * @return
	 */
	public GiResult<T> andCode(int code);
	/**
	 * 设置状态码
	 * @param code
	 * @return
	 */
	default public GiResult<T> andCode(GiResultCode code){
		return andCode(code.value());
	}
	
	/**
	 * 获取提示消息
	 * @return
	 */
	public String alertMsg();
	
	/**
	 * 设置提示信息
	 * @param msg
	 * @return
	 */
	public GiResult<T> andAlertMsg(String msg);
	
	/**
	 * 获取消息提示类型
	 * @return
	 */
	public int alertType();
	
	/**
	 * 设置消息提示类型
	 * @param alertType
	 * @return
	 */
	public GiResult<T> andAlertType(int alertType);
	
	/**
	 * 设置消息提示类型
	 * @param alertTypeEnum
	 * @return
	 */
	default public GiResult<T> andAlertTypeEnum(GwEmAlertType alertTypeEnum){
		return andAlertType(alertTypeEnum.value());
	}
	
	/**
	 * 设置结果数据
	 * @param value
	 * @return
	 */
	public GiResult<T> andValue(T value);

	/**
	 * 成功状态
	 * @return
	 */
	public GiResult<T> forSuccess();
	
	/**
	 * 成功提示消息
	 * @param msg
	 * @return
	
	default public GiResult<T> forSuccessAlertMsg(String msg){
		return this.forSuccess().andAlertMsg(msg);
	} */
	
	/**
	 * 失败状态
	 * @return
	 */
	public GiResult<T> forFailure();
	
	/**
	 * 失败提示消息
	 * @param msg
	 * @return
	 
	default public GiResult<T> forFailureAlertMsg(String msg){
		return this.forFailure().andAlertMsg(msg);
	}*/
	
	/**
	 * 失败设置
	 * @param code
	 * @param msg
	 * @param alertType
	 * @return
	 
	default public GiResult<T> forFailureSetCodeAndMsgAndType(int code,String msg,GwEmAlertType alertType){
		return this.forFailureAlertMsg(msg).andAlertTypeEnum(alertType).andCode(code);
	}*/
	
	
	//--------------------------------------------------------------------------------------------------------------------
	
	
	/**
	 * 成功 + 结果
	 * @param <K>
	 * @param value
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static<K> GiResult<K> successValue(K value){
		Class<K> cls = null;
		if(value != null) {
			cls = (Class<K>)value.getClass();
		}
		return getResult(cls).andValue(value);
	}
	/**
	 * 成功
	 * @param <K>
	 * @return
	 */
	public static<K> GiResult<K> success(){
		return GiResult.<K>successValue(null).forSuccess();
	}
	
	/**
	 * 成功 + 消息
	 * @param <K>
	 * @param msg
	 * @return
	 */
	public static<K> GiResult<K> successMsg(String msg){
		return GiResult.<K>success().andAlertMsg(msg);
	}
	/**
	 * 失败
	 * @param <K>
	 * @return
	 */
	public static<K> GiResult<K> failure(){
		return GiResult.<K>getResult(null).forFailure();
	}

	/**
	 * 失败 + 消息
	 * @param <K>
	 * @param msg
	 * @return
	 */
	public static<K> GiResult<K> failureMsg(String msg){
		return GiResult.<K>failure().andAlertMsg(msg);
	}

	/**
	 * 失败 + 消息 + 消息提示类型
	 * @param <K>
	 * @param msg
	 * @param alertType
	 * @return
	 */
	public static<K> GiResult<K> failureSetMsgAndType(String msg,GwEmAlertType alertType){
		return GiResult.<K>failureMsg(msg).andAlertTypeEnum(alertType);
	}
	
	/**
	 * 失败 + 状态 +消息 + 消息提示类型
	 * @param <K>
	 * @param code
	 * @param msg
	 * @param alertType
	 * @return
	 */
	public static<K> GiResult<K> failureSetCodeAndMsgAndType(int code ,String msg,GwEmAlertType alertType){
		return GiResult.<K>failureMsg(msg).andAlertTypeEnum(alertType).andCode(code);
	}
	
	/**
	 * 获取结果对象
	 * @param <K>
	 * @param resultType
	 * @return
	 */
	public static<K> GiResult<K> getResult(Class<K> resultType){
		return GwSpHelper.load(GiResultConfig.class).getResult(resultType);
	}
	
}
