package com.gw.base.data.support;

import com.gw.base.data.GiGroup;
import com.gw.base.data.GiGroupType;
import com.gw.base.data.common.GemBoolean;
import com.gw.base.data.model.annotation.GaModelField;

@SuppressWarnings("serial")
public class GwGroupKid implements GiGroup {
	
	public static GwGroupKid valueOf(GiGroupType groupType,String gwGroupId,String gwGroupName) {
		return new GwGroupKid(GwGroupTypeKid.valueFor(groupType.gwTypeId()),gwGroupId,gwGroupName);
	}
	
	
	@GaModelField(isID=true)
	private String gwGroupId;
	
	@GaModelField(isDisplay = true)
	private String gwGroupName;
	
	
	@GaModelField()
	private GwGroupTypeKid gwGroupType;

	@Override
	public String gwGroupId() {
		return gwGroupId;
	}
	
	public GwGroupKid() {}
	
	
	public GwGroupKid(GwGroupTypeKid groupType,String gwGroupId,String gwGroupName) {
		this.gwGroupId = gwGroupId;
		this.gwGroupName = gwGroupName;
		this.gwGroupType = groupType;
	}
	
	public GwGroupTypeKid gwType() {
		return gwGroupType;
	}
	
	@Override
	public String gwGroupName() {
		return gwGroupName;
	}

	public String getGwGroupId() {
		return gwGroupId;
	}

	public GwGroupKid setGwGroupId(String gwGroupId) {
		this.gwGroupId = gwGroupId;
		return this;
	}

	public String getGwGroupName() {
		return gwGroupName;
	}

	public GwGroupKid setGwGroupName(String gwGroupName) {
		this.gwGroupName = gwGroupName;
		return this;
	}

	public GwGroupTypeKid getGwGroupType() {
		return gwGroupType;
	}

	public void setGwGroupType(GwGroupTypeKid gwGroupType) {
		this.gwGroupType = gwGroupType;
	}
	

}
