package com.gw.base.data.support;

import java.util.HashMap;
import java.util.Map;
import com.gw.base.data.GiGroupType;
import com.gw.base.data.GiType;

public class GwGroupTypeKid extends GwTypeKid implements GiGroupType{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3835856895881043495L;
	
	
	private static final Map<String,GwGroupTypeKid> typeGroupTypes = new HashMap<>();
	
	public static GwGroupTypeKid valueOf(GiType gwType) {
		if(typeGroupTypes.containsKey(gwType.gwTypeId())) {
			return valueFor(gwType.gwTypeId());
		}else {
			GwGroupTypeKid kid = new GwGroupTypeKid();
			kid.setGwTypeId(gwType.gwTypeId());
			kid.setGwTypeName(gwType.gwTypeName());
			typeGroupTypes.put(gwType.gwTypeId(), kid);
			return kid;
		}
	}

	public static GwGroupTypeKid valueFor(String gwGroupTypeId) {
		return typeGroupTypes.get(gwGroupTypeId);
	}
	
}
