package com.gw.base.env.property;

import com.gw.base.def.GkOperater;

public interface GiPropertier extends GkOperater{
	
	/**
	 * 是否包含属性
	 * @param key
	 * @return
	 */
	boolean containsProperty(String key);
	
	/**
	 * 获取属性
	 * @param key
	 * @return
	 */
	String getProperty(String key);
	/**
	 * 获取属性
	 * @param key
	 * @return
	 */
	String getProperty(String key, String defaultValue);
	/**
	 * 获取属性
	 * @param key
	 * @return
	 */
	<T> T getProperty(String key, Class<T> targetType);
	/**
	 * 获取属性
	 * @param key
	 * @return
	 */
	<T> T getProperty(String key, Class<T> targetType, T defaultValue);
	/**
	 * 获取属性 没有就报错
	 * @param key
	 * @return
	 */
	String getRequiredProperty(String key) throws IllegalStateException;
	/**
	 * 获取属性
	 * @param key
	 * @return
	 */
	<T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException;
	/**
	 * 获取属性
	 * @param key
	 * @return
	 */
	String resolvePlaceholders(String text);
	/**
	 * 获取属性
	 * @param key
	 * @return
	 */
	String resolveRequiredPlaceholders(String text) throws IllegalArgumentException;
}
