package com.gw.base.exception;


import java.util.IdentityHashMap;
import java.util.Map;
import com.gw.base.data.GwValidateException;
import com.gw.base.data.result.GiResult;
import com.gw.base.data.result.GwEmAlertType;
import com.gw.base.permission.GwPermissionException;
import com.gw.base.user.GwNoLoginException;

public abstract class GwExceptionResultConverter {
	
	
	private static final Map<Class<? extends Exception>,Integer> primitiveExceptionCodeMap = new IdentityHashMap<Class<? extends Exception>,Integer>(8);
	
	
	static {
		primitiveExceptionCodeMap.put(Exception.class, 999);
		primitiveExceptionCodeMap.put(GwException.class, 998);
		primitiveExceptionCodeMap.put(GwNoLoginException.class, 399);
		primitiveExceptionCodeMap.put(GwPermissionException.class, 799);
		primitiveExceptionCodeMap.put(GwValidateException.class, 499);
	}
	
	
	
	public static void regExceptionCode(Class<? extends Exception> exCls,Integer code){
		primitiveExceptionCodeMap.put(exCls, code);
	}
	
	@SuppressWarnings("unchecked")
	public static Integer getExceptionCode(Class<? extends Exception> exCls){
		if(primitiveExceptionCodeMap.containsKey(exCls)) {
			return primitiveExceptionCodeMap.get(exCls);
		}else {
			return getExceptionCode((Class<? extends Exception>)exCls.getSuperclass());
		}
	}
	
	
	
	
	private static final Map<Class<? extends Exception>,Integer> primitiveExceptionAlertTypeMap = new IdentityHashMap<Class<? extends Exception>,Integer>(8);
	

	static {
		primitiveExceptionAlertTypeMap.put(Exception.class, GwEmAlertType.不弹框0.value());
		primitiveExceptionAlertTypeMap.put(GwException.class, GwEmAlertType.无需关闭的错误3.value());
		primitiveExceptionAlertTypeMap.put(GwNoLoginException.class, GwEmAlertType.无需关闭的错误3.value());
		primitiveExceptionAlertTypeMap.put(GwPermissionException.class, GwEmAlertType.无需关闭的提示1.value());
		primitiveExceptionAlertTypeMap.put(GwValidateException.class, GwEmAlertType.无需关闭的提示1.value());
	}


	
	public static void regExceptionAlertType(Class<? extends Exception> exCls,GwEmAlertType alertType){
		primitiveExceptionAlertTypeMap.put(exCls, alertType.value());
	}

	public static void regExceptionAlertType(Class<? extends Exception> exCls,Integer alertType){
		primitiveExceptionAlertTypeMap.put(exCls, alertType);
	}
	
	@SuppressWarnings("unchecked")
	public static Integer getExceptionAlertType(Class<? extends Exception> exCls){
		if(primitiveExceptionAlertTypeMap.containsKey(exCls)) {
			return primitiveExceptionAlertTypeMap.get(exCls);
		}else {
			return getExceptionAlertType((Class<? extends Exception>)exCls.getSuperclass());
		}
	}
	
	
	public static GiResult<Exception> convert(Exception ex){
		GiResult<Exception> res = GiResult.getResult(Exception.class);
		res.andAlertMsg(ex.getMessage());
		res.andValue(ex);
		res.andCode(getExceptionCode(ex.getClass()));
		res.andAlertType(getExceptionAlertType(ex.getClass()));
		return res;
	}

	/*
	public static GiResult<IllegalArgumentException> checkDataConvert(IllegalArgumentException ex){
		GiResult<IllegalArgumentException> res = GiResult.getResult(IllegalArgumentException.class);
		res.setAlertMsg(ex.getMessage());
		res.setValue(ex);
		res.setCode(899);
		res.setAlertType(GwEmAlertType.无需关闭的提示1.value());
		return res;
	}
	*/
	
}