package com.gw.base.gpa.dao;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import com.gw.base.bean.GwBeanException;
import com.gw.base.bean.GwBeanHelper;
import com.gw.base.bean.GwNoUniqueBeanException;
import com.gw.base.gpa.entity.GiEntityAutoIdable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.gpa.id.GiEntityIdGenerator;

public interface GiCreateDao<M extends GiEntitySaveable<PK>,PK extends Serializable> extends GiDao<M,PK>  {
	
	@SuppressWarnings("unchecked")
	public static<M extends GiEntitySaveable<PK>,PK extends Serializable> GiCreateDao<M,PK> getDao(Class<M> modelCls) {
		return (GiCreateDao<M,PK>)GiDao.getDao(GiCreateDao.class, modelCls);
	}
	
	
	/**
	 * 处理自动主键
	 * @param t
	 */
    default void processPK(M t) {
    	if(t.id() == null) {
    		if(GiEntityAutoIdable.class.isAssignableFrom((t.getClass()))) {
				((GiEntityAutoIdable<PK>) t).autoId();
			}
    	}
    	if(t.id() == null){
			GiEntityIdGenerator<M,PK> idGenerator = null;
			try {
				idGenerator = GwBeanHelper.getProvider().getBean(GiEntityIdGenerator.class, new Type[] {t.modelClass(), t.idClass()});
			}catch (GwNoUniqueBeanException ex){
				throw ex;
			}catch (GwBeanException ex){
				throw ex;
			}
			if(idGenerator != null) {
				idGenerator.generatorId(t);
			}
		}
    }
	
    /**
     * 保存一条记录(属性不判空，为空的属性插入为空，无视数据库默认值(由于orm框架会判断字段注解@Column(insertable=false)时不处理字段，所以也不能说完全无视数据库默认值，前提是插入语句包含该字段))
     * 
     * @param t 实体对象
     * @return PK 主键
     */
    PK gwAccess(M t);

    /**
     * 批量插入(属性不判空，为空的属性插入为空，无视数据库默认值(由于orm框架会判断字段注解@Column(insertable=false)时不处理字段，所以也不能说完全无视数据库默认值，前提是插入语句包含该字段))
     * @param records
     * @return 主键 List<PK>
     */
    List<PK> gwAccess(List<M> records);
    
    /**
     * 插入一条记录(属性判空，为空的属性不做插入操作)
     * @param t 实体对象
     * @return PK 主键
     */
    PK gwAccessSelective(M t);
    
    /**
     * 批量插入(属性判空，为空的属性不做插入操作)批量插入语句字段是固定的。所以默认实现只是循环
     * @param records
     * @return 主键 List<PK>
     */
	default List<PK> gwAccessSelective(List<M> records){
    	
    	List<PK> res = new ArrayList<>();
    	for(M item : records) {
    		this.processPK(item);
    		res.add(this.gwAccessSelective(item));
    	}
    	return res;
    }
    
}
