package com.gw.base.gpa.dao;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import com.gw.base.bean.GwBeanHelper;
import com.gw.base.data.model.GiModelable;
import com.gw.base.util.GutilClass;

public interface GiDao<M extends GiModelable<PK>,PK extends Serializable>{
	
	/**
	 * 通过Dao类型和模型类型获取Dao实例
	 * @param <DAO>
	 * @param <M>
	 * @param <PK>
	 * @param daoCls
	 * @param modelCls
	 * @return Dao实例
	 */
	public static <DAO extends GiDao<M,PK>,M extends GiModelable<PK>,PK extends Serializable> DAO getDao(Class<DAO> daoCls,Class<M> modelCls) {
		return GwBeanHelper.getProvider().getBean(daoCls, new Type[] {modelCls,GiModelable.getIDClass(modelCls)});
	}
	
	
	public static Type[] getDaoGenericTypes(Class<?> daoClass) {
		
		Type[] genericInterfaces = daoClass.getGenericInterfaces();
		for(Type type:genericInterfaces) {
			if (type instanceof ParameterizedType) {
				ParameterizedType pType = (ParameterizedType) type;
				
				if(GiDao.class.isAssignableFrom((Class<?>)pType.getRawType())) {
					
					Type[] ts = pType.getActualTypeArguments();
					
					if(ts.length == 2) {
						if(GiModelable.class.isAssignableFrom((Class<?>)ts[0]) && Serializable.class.isAssignableFrom((Class<?>)ts[1])) {
							return ts;
						}
					}
				}
			}
			if(type instanceof Class && GiDao.class.isAssignableFrom((Class<?>)type)) {
				return getDaoGenericTypes((Class<?>)type);
			}
		}
		return null;
	}
	
	@SuppressWarnings("unchecked")
	default Class<M> getModelClass(){
        return (Class<M>)getDaoGenericTypes(GutilClass.getUserClass(this.getClass()))[0];
    }
	
	@SuppressWarnings("unchecked")
	default Class<PK> getPKClass() {
        return (Class<PK>)getDaoGenericTypes(GutilClass.getUserClass(this.getClass()))[1];
    }
    
}
