package com.gw.base.gpa.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

import com.gw.base.data.page.GiPageParam;
import com.gw.base.data.page.GiPager;
import com.gw.base.gpa.entity.GiEntityQueryable;

/**
 * 分页查询
 *
 * @author Ray
 */
public interface GiPagerDao<M extends GiEntityQueryable<PK>, PK extends Serializable> extends GiDao<M, PK> {

    @SuppressWarnings({"unchecked"})
    public static <M extends GiEntityQueryable<PK>, PK extends Serializable> GiPagerDao<M, PK> getDao(Class<M> modelCls) {
        return GiDao.getDao(GiPagerDao.class, modelCls);
    }

    
    
    default GiPager<M> getModelPager() {
    	Class<M> modelClass = this.getModelClass();
        return GiPager.ofClass(modelClass);
    }
    
    /**
     * 分页查询单表所有记录
     *
     * @return
     */
    GiPager<M> gwSearchPageAll(GiPageParam pageParam);

    /**
     * 根据PO条件分页查询多条记录
     *
     * @param t
     * @return
     */
    GiPager<M> gwSearchPage(M t,GiPageParam pageParam);
    
    /**
     * 根据主键分页查询
     *
     * @param
     * @return
     */
    GiPager<M> gwSearchPageByPK(List<PK> pks,GiPageParam pageParam);
    /**
     * 根据主键分页查询
     *
     * @param
     * @return
     */
    default GiPager<M> gwSearchPageByPK(PK[] pks,GiPageParam pageParam){
    	return this.gwSearchPageByPK(Arrays.asList(pks), pageParam);
    }

    /**
     * 根据Example条件分页查询多条记录
     *
     * @param t
     * @param t
     * @return
     */
//    default GwPager<M> searchByExamplePage(Object example) {
//        Class<M> modelClass = this.getModelClass();
//        GwRetrieveDao<M, PK> selectDao = GwRetrieveDao.<M, PK>getDao(modelClass);
//        GwPager<M> pager = this.getGwPager(modelClass);
//        GwPageExcute<M> exec = new GwPageExcute<M>() {
//            @Override
//            public GwPager<M> getGwPager() {
//                return pager;
//            }
//
//            @Override
//            public List<M> excute() {
//                return selectDao.search(example);
//            }
//        };
//
//        return getPageExcuter().excutePage(exec, getPageParam());
//    }
}