package com.gw.base.gpa.dao;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.gw.base.gpa.entity.GiEntityQueryable;
/**
 * 查询Dao
 * @author Ray
 *
 */
public interface GiRetrieveDao<M extends GiEntityQueryable<PK>,PK extends Serializable> extends GiDao<M,PK> {
	
	@SuppressWarnings("unchecked")
	public static<M extends GiEntityQueryable<PK>,PK extends Serializable> GiRetrieveDao<M,PK> getDao(Class<M> modelCls) {
		return GiDao.getDao(GiRetrieveDao.class, modelCls);
	}
	
	/**
     * 是否能够找到主键的记录
     * @param pk 
     * @return
     */
	boolean gwExistsWithPK(PK pk);
	
    /**
     * 根据主键查询记录
     * @param pk 
     * @return
     */
	M gwSearchByPK(PK pk);
	/**
	 * 根据多个主键查询多个结果
	 * @param pks
	 * @return
	 */
	List<M> gwSearchByPK(Set<PK> pks);
	default List<M> gwSearchByPK(PK[] pks){
		Set<PK> set = new HashSet<>();
		for (PK str : pks) {
			set.add(str);
		}
		return gwSearchByPK(set);
	}
	default List<M> gwSearchByPK(List<PK> pks){
		return gwSearchByPK(new HashSet<PK>(pks));
	}
	
    /**
     * 根据实体中的属性进行查询，只能有一个返回值，有多个结果时抛出异常，查询条件使用等号
     * @param t
     * @return
     */
    M gwSearchOne(M t);
    /**
     * 根据实体中的属性进行查询，只返回第一条数据,查询条件使用等号
     * @param t
     * @return
     */
    M gwSearchFirst(M t);
    
    /**
     * 查询单表所有记录
     * @return
     */
    List<M> gwSearchAll();
    /**
     * 根据条件查询多条记录
     * @param t
     * @return
     */
    List<M> gwSearch(M t);
    /**
     * 根据条件查询总数
     * @param t
     * @return
     */
    long gwSearchCount(M t);
    /**
     * 查询总数
     * @param t
     * @return
     */
    long gwSearchCount();

//	/**
//	 * 通过 example 条件查询
//	 * @param example
//	 * @return
//	 */
//
//	List<M> searchByExample(Object  example);
}
