package com.gw.base.gpa.dao;

import java.io.Serializable;
import java.util.List;
import com.gw.base.gpa.entity.GiEntityAlterable;

public interface GiUpdateDao<M extends GiEntityAlterable<PK>,PK extends Serializable> extends GiDao<M,PK> {
	
	@SuppressWarnings("unchecked")
	public static<M extends GiEntityAlterable<PK>,PK extends Serializable> GiUpdateDao<M,PK> getDao(Class<M> modelCls) {
		return GiDao.getDao(GiUpdateDao.class, modelCls);
	}
	
    /**
     * 根据主键更新记录(更新所有字段)
     * @param t
     * @return
     */
    void gwUpdateByPK(M t);

    /**
     * 根据主键更新记录(更新不为Null的字段)
     * @param t
     * @return
     */
    void gwUpdateByPKSelective(M t);

    /**
     * 根据主键批量更新
     * @param records
     * @return
     */
    void gwUpdateByPK(List<M> records);
    
    /**
     * 根据主键批量更新(更新不为Null的字段)
     * @param records
     * @return
     */
    void gwUpdateByPKSelective(List<M> records);
}
