package com.gw.base.gpa.entity;

import java.io.Serializable;
import com.gw.base.gpa.dao.GiUpdateDao;

/**
 * 可以更新的实体
 * @author Ray
 *
 * @param <PK> 主键类型
 */
public interface GiEntityAlterable<PK extends Serializable> extends GiEntityable<PK> {
	
	@SuppressWarnings("unchecked")
	default <M extends GiEntityAlterable<PK>> GiUpdateDao<M,PK> updateDao(){
		return GiUpdateDao.getDao((Class<M>)this.getClass());
	}
	
	default void alterByPK() {
		this.updateDao().gwUpdateByPK(this);
	}
	
	default void alterByPKSelective() {
		this.updateDao().gwUpdateByPKSelective(this);
	}
	
}
