package com.gw.base.gpa.entity;

import java.io.Serializable;

import com.gw.base.gpa.dao.GiCreateDao;

/**
 * 可以保存的模型
 * @author Ray
 *
 * @param <ID> 主键类型
 */
public interface GiEntitySaveable<ID extends Serializable> extends GiEntityable<ID> {
	
	
	@SuppressWarnings("unchecked")
	default <T extends GiEntitySaveable<ID>> GiCreateDao<T,ID> insertDao(){
		return GiCreateDao.getDao((Class<T>)this.modelClass());
	}
	
	default void save() {
		this.insertDao().gwAccess(this);
	}
	
	
	default void saveSelective() {
		this.insertDao().gwAccessSelective(this);
	}
	
}
