package com.gw.base.json;

import com.gw.base.exception.GwException;
import com.gw.base.util.GutilStr;

public class GwJSONException extends  GwException {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -2014231003542321867L;
	
	

	public GwJSONException(Throwable e) {
		super(getMessage(e), e);
	}

	private static String getMessage(Throwable e) {
		if (null == e) {
			return GutilStr.NULL;
		}
		return GutilStr.format("{}: {}", e.getClass().getSimpleName(), e.getMessage());
	}
	
	public GwJSONException(String message) {
		super(message);
	}
	
	public GwJSONException(String messageTemplate, Object... params) {
		super(GutilStr.format(messageTemplate, params));
	}

	public GwJSONException(String message, Throwable cause) {
		super(message, cause);
	}

	public GwJSONException(Throwable throwable, String messageTemplate, Object... params) {
		super(GutilStr.format(messageTemplate, params), throwable);
	}
}
