package com.gw.base.permission;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public interface GiPermissionHandler<P extends GiPermissionable>{
	
	
	default public Class<P> permissionTypeClass(){
		return (Class<P>)getHandlerGenericTypes(this.getClass());
	}

	public static Type getHandlerGenericTypes(Class<?> handlerClass) {

		Type[] genericInterfaces = handlerClass.getGenericInterfaces();
		for(Type type:genericInterfaces) {
			if (type instanceof ParameterizedType) {
				ParameterizedType pType = (ParameterizedType) type;

				if(GiPermissionHandler.class.isAssignableFrom((Class<?>)pType.getRawType())) {

					Type[] ts = pType.getActualTypeArguments();

					if(ts.length == 1) {
						if(GiPermissionable.class.isAssignableFrom((Class<?>)ts[0])) {
							return ts[0];
						}
					}
				}
			}
			if(type instanceof Class && GiPermissionHandler.class.isAssignableFrom((Class<?>)type)) {
				return getHandlerGenericTypes((Class<?>)type);
			}
		}
		return null;
	}

	
    default public boolean permissionHandle(Method method) throws Exception {

    	boolean needCheck = false;
    	Annotation[] as = method.getAnnotations();

        for (Annotation an : as) {
        	
        	if(an.annotationType() == GaPermission.class) {
        		needCheck  = true;
        		
        	}
    	}

        /*
        if(needCheck) {
			GiPermissionable user = GiActiver.getActive(permissionTypeClass());
        	
        	if(user == null) {
        		throw new GwPermissionException("请先认证");
        	}else {
        		
        		user.permissions();
        		
        	}
        }
         */
        return true;
    }
 
}
