package com.gw.base.user;

import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.permission.GiPermission;
import com.gw.base.session.GiSession;
import com.gw.base.user.permission.GiPermissionUser;
import com.gw.base.user.session.GiSessionUser;
import java.io.Serializable;
import java.util.Collection;

public interface GiPermissionSessionUser<ID extends Serializable> extends GiSessionUser<ID>,GiPermissionUser<ID> {
  
	
	
	public static GiLoger logger = GwLoger.getLoger(GiPermissionSessionUser.class);


	public static <T extends GiSessionUser<?>> String getPermissionKeyInSession(Class<T> userClass){
		return "gw-session-permission-" + userClass.getName();
	}


    /**
     * 设定用户为登录状态
     * @return 返回会话id
     */
    @Override
	default public void sessionLogin() {
		GiSessionUser.super.sessionLogin();
		this.permissions();
	}
	
	/**
     * 设定用户为登出状态
     * @return 
     */
    @Override
	default public void sessionLogout() {
    	GiSession session = userSession(false);
		if(session != null) {

			session.removeAttribute(getPermissionKeyInSession(sessionUserType()));
		}
		GiSessionUser.super.sessionLogout();
	}
    
	
	@Override
	default public Collection<? extends GiPermission> permissions(){
    	GiSession session = userSession(true);
    	Object obj = session.getAttribute(getPermissionKeyInSession(sessionUserType()));
    	if(obj == null) {
    		Collection<? extends GiPermission> res = GiPermissionUser.super.permissions();
    		session.setAttribute(getPermissionKeyInSession(sessionUserType()), res);
    		return res;
    	}
    	return (Collection<? extends GiPermission>)obj;
	}

}
