package com.gw.base.user;


import com.gw.base.active.GiActivable;
import com.gw.base.active.GiActiver;
import com.gw.base.user.session.GiSessionUser;
import java.io.Serializable;

public interface GiUser<ID extends Serializable> extends Serializable{


	public static <T extends GiUser<?>> T getUser(Class<T> userClass) {

		T res = null;

		if(GiActivable.class.isAssignableFrom(userClass)){
			res = (T) GiActiver.getActive((Class<? extends GiActivable>)userClass);
		}

		if(res == null && GiSessionUser.class.isAssignableFrom(userClass)){
			res = (T)GiSessionUser.getUser((Class<? extends GiSessionUser>)userClass);
		}
		return res;
	}

	
	ID userId();
	
	/**
	 * 是否是测试用户
	 * @return
	 */
    default boolean isTest() {
    	return false;
    }
}
