package com.gw.base.user;

import com.gw.base.exception.GwException;
import com.gw.base.util.GutilStr;

/**
 * 异常
 * 
 */

@SuppressWarnings("serial")
public class GwNoLoginException extends GwException {

	public GwNoLoginException() {
		this("未登录");
	}
	public GwNoLoginException(String msg) {
		super(msg);
	}
	
	public GwNoLoginException(String msg, Throwable cause) {
		super(msg, cause);
	}
	
	public GwNoLoginException(String messageTemplate, Object... params) {
		super(GutilStr.format(messageTemplate, params));
	}
	
	public GwNoLoginException(Throwable throwable, String messageTemplate, Object... params) {
		super(GutilStr.format(messageTemplate, params), throwable);
	}

}
