package com.gw.base.user.permission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import com.gw.base.permission.GiPermission;
import com.gw.base.permission.GiPermissionable;
import com.gw.base.permission.support.GwPermissionKid;
import com.gw.base.user.GiUser;
import com.gw.base.util.GutilCollection;

public interface GiPermissionUser<ID extends Serializable> extends GiUser<ID>,GiPermissionable {
	
	default public Class<? extends GiPermissionUser> permissionType(){
		return this.getClass();
	}
	
	@Override
	default public Collection<? extends GiPermission> permissions(){
		
		List<GwPermissionKid> res =  new ArrayList<>();
		Collection<? extends GiPermission> ps = GiUserPermissionProvider.getProvider(this.permissionType()).userPermissions(this);
		if(!GutilCollection.isEmpty(ps)) {
			for(GiPermission item : ps) {
				res.add(new GwPermissionKid(item));
			}
		}
		return res;
	}
	
	/**
	 * 是否是超级管理员用户
	 * @return
	 */
    default boolean isAdmin() {
    	return false;
    }
}
