package com.gw.base.user.role;

import java.lang.reflect.Type;
import java.util.Collection;

import com.gw.base.Gw;
import com.gw.base.bean.GwBeanHelper;
import com.gw.base.user.GiUser;

/**
 * 用户角色提供者接口
 * @author Ray
 *
 * @param <U>
 */

public interface GiUserRoleProvider<U extends GiUser<?>> {
	
	@SuppressWarnings("unchecked")
	public static <T extends GiUser<?>> GiUserRoleProvider<T> getProvider(Class<T> userClass) {
		return Gw.beans.getBean(GiUserRoleProvider.class,new Type[] {userClass});
	}

	public Collection<? extends GiUserRole> userRoles(GiUser<?> gwUser);
	
}
