package com.gw.base.user.session;

import java.io.Serializable;
import com.gw.base.active.GiActivable;
import com.gw.base.session.GiSession;
import com.gw.base.user.GiUser;

public interface GiSessionUser<ID extends Serializable> extends GiUser<ID> {


	public static <T extends GiSessionUser<?>> String getUserKeyInSession(Class<T> userClass){
		return "gw-session-user-" + userClass.getName();
	}

	public static <T extends GiSessionUser<?>> T getUser(Class<T> userClass) {
		
		GiUserSessionProvider<T> provider = GiUserSessionProvider.getProvider(userClass);
		GiSession session = provider.userSession(false);
		
		if(session != null) {
    		Object obj = session.getAttribute(getUserKeyInSession(userClass));
    		if(obj != null) {
    			return (T)obj;
    		}
		}
		return null;
	}

	/*
	default public String keyUserInSession(){
		return "gw-sessionuser-" + this.getClass().getName();
	}
	 */

	default public <T extends GiSessionUser<?>> Class<T> sessionUserType(){
		return (Class<T>)this.getClass();
	}
	
	default GiSession userSession(boolean autoCreate) {
		return GiUserSessionProvider.getProvider(sessionUserType()).userSession(autoCreate);
	}
	
	default void sessionLogin() {
		userSession(true).setAttribute(getUserKeyInSession(sessionUserType()), this);
		if(this instanceof GiActivable){
			((GiActivable)this).active();
		}
	}
	
	default void sessionLogout() {
		if(this instanceof GiActivable){
			((GiActivable)this).deactive();
		}
		GiSession session = userSession(false);
		if(session != null) {
			session.removeAttribute(getUserKeyInSession(sessionUserType()));
		}
	}
	
}
