package com.gw.base.util;

import java.lang.reflect.Proxy;
import com.gw.base.lang.invoke.GkMethodHand;
import com.gw.base.lang.invoke.GaMethodHandDefine;

public class GutilAop {

	
	
	/**
	 * Check whether the given object is a JDK dynamic proxy or a CGLIB proxy.
	 * <p>This method additionally checks if the given object is an instance
	 * of {@link SpringProxy}.
	 * @param object the object to check
	 * @see #isJdkDynamicProxy
	 * @see #isCglibProxy
	 */
	@GaMethodHandDefine(expectClassName = "org.springframework.aop.support.AopUtils",expectMethodName = "isAopProxy")
	public static boolean isAopProxy(Object object) {
		return (boolean)GkMethodHand.invokeSelf(object);
	}

	/**
	 * Check whether the given object is a JDK dynamic proxy.
	 * <p>This method goes beyond the implementation of
	 * {@link Proxy#isProxyClass(Class)} by additionally checking if the
	 * given object is an instance of {@link SpringProxy}.
	 * @param object the object to check
	 * @see java.lang.reflect.Proxy#isProxyClass
	 */
	@GaMethodHandDefine(expectClassName = "org.springframework.aop.support.AopUtils",expectMethodName = "isJdkDynamicProxy")
	public static boolean isJdkDynamicProxy(Object object) {
		return (boolean)GkMethodHand.invokeSelf(object);
	}

	/**
	 * Check whether the given object is a CGLIB proxy.
	 * <p>This method goes beyond the implementation of
	 * {@link ClassUtils#isCglibProxy(Object)} by additionally checking if
	 * the given object is an instance of {@link SpringProxy}.
	 * @param object the object to check
	 * @see ClassUtils#isCglibProxy(Object)
	 */
	@GaMethodHandDefine(expectClassName = "org.springframework.aop.support.AopUtils",expectMethodName = "isCglibProxy")
	public static boolean isCglibProxy(Object object) {
		return (boolean)GkMethodHand.invokeSelf(object);
	}

	/**
	 * Determine the target class of the given bean instance which might be an AOP proxy.
	 * <p>Returns the target class for an AOP proxy or the plain class otherwise.
	 * @param candidate the instance to check (might be an AOP proxy)
	 * @return the target class (or the plain class of the given object as fallback;
	 * never {@code null})
	 * @see org.springframework.aop.TargetClassAware#getTargetClass()
	 * @see org.springframework.aop.framework.AopProxyUtils#ultimateTargetClass(Object)
	 */
	@GaMethodHandDefine(expectClassName = "org.springframework.aop.support.AopUtils",expectMethodName = "getTargetClass")
	public static Class<?> getTargetClass(Object candidate) {
		return (Class<?>)GkMethodHand.invokeSelf(candidate);
	}
}
