/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.cache.support;

import com.gw.base.cache.GiCache;
import com.gw.base.cache.GiCacheManager;
import com.gw.base.cache.support.GwTtlMapCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GwMemoryCacheManager
implements GiCacheManager {
    private final ConcurrentMap<String, GiCache> cacheMap = new ConcurrentHashMap<String, GiCache>(16);
    private boolean dynamic = true;
    private boolean allowNullValues = true;
    private boolean storeByValue = false;

    public GwMemoryCacheManager() {
    }

    public GwMemoryCacheManager(String ... cacheNames) {
        this.setCacheNames(Arrays.asList(cacheNames));
    }

    public void setCacheNames(Collection<String> cacheNames) {
        if (cacheNames != null) {
            for (String name : cacheNames) {
                this.cacheMap.put(name, this.createConcurrentMapCache(name));
            }
            this.dynamic = false;
        } else {
            this.dynamic = true;
        }
    }

    public void setAllowNullValues(boolean allowNullValues) {
        if (allowNullValues != this.allowNullValues) {
            this.allowNullValues = allowNullValues;
            this.recreateCaches();
        }
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public void setStoreByValue(boolean storeByValue) {
        if (storeByValue != this.storeByValue) {
            this.storeByValue = storeByValue;
            this.recreateCaches();
        }
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    @Override
    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GiCache getCache(String name) {
        GiCache cache = (GiCache)this.cacheMap.get(name);
        if (cache == null && this.dynamic) {
            ConcurrentMap<String, GiCache> concurrentMap = this.cacheMap;
            synchronized (concurrentMap) {
                cache = (GiCache)this.cacheMap.get(name);
                if (cache == null) {
                    cache = this.createConcurrentMapCache(name);
                    this.cacheMap.put(name, cache);
                }
            }
        }
        return cache;
    }

    private void recreateCaches() {
        for (Map.Entry entry : this.cacheMap.entrySet()) {
            entry.setValue(this.createConcurrentMapCache((String)entry.getKey()));
        }
    }

    protected GiCache createConcurrentMapCache(String name) {
        return new GwTtlMapCache(name);
    }
}

