/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.cache.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GwTtlMap<K, V>
implements Map<K, V> {
    private Map<K, V> hashMap;
    private Map<K, Long> timeMap;
    private Long long_minus_1 = -1L;

    public GwTtlMap(int initialCapacity, float loadFactor) {
        this.hashMap = new ConcurrentHashMap(initialCapacity, loadFactor);
        this.timeMap = new ConcurrentHashMap<K, Long>(initialCapacity, loadFactor);
    }

    public GwTtlMap(int initialCapacity) {
        this.hashMap = new ConcurrentHashMap(initialCapacity);
        this.timeMap = new ConcurrentHashMap<K, Long>(initialCapacity);
    }

    public GwTtlMap() {
        this.hashMap = new ConcurrentHashMap();
        this.timeMap = new ConcurrentHashMap<K, Long>();
    }

    public long expire(K key, long milliseconds) {
        if (milliseconds < 0L) {
            return this.expire_(key, this.long_minus_1);
        }
        return this.expire_(key, milliseconds);
    }

    private long expire_(K key, Long milliseconds) {
        Iterator<Map.Entry<K, Long>> it = this.timeMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, Long> entry = it.next();
            if (!entry.getKey().equals(key)) continue;
            long tm = entry.getValue();
            if ((tm == -1L || tm - System.currentTimeMillis() > 0L) && milliseconds != null && milliseconds != 0L) {
                if (milliseconds < 0L) {
                    entry.setValue(this.long_minus_1);
                    return -1L;
                }
                long lv = System.currentTimeMillis() + milliseconds;
                entry.setValue(lv);
                return lv;
            }
            this.hashMap.remove(key);
            it.remove();
            return 0L;
        }
        return 0L;
    }

    public long pttl(K key) {
        return this.pttl_(key);
    }

    private long pttl_(K key) {
        Iterator<Map.Entry<K, Long>> it = this.timeMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, Long> entry = it.next();
            if (!entry.getKey().equals(key)) continue;
            Long tm = entry.getValue();
            if (tm < 0L) {
                return -1L;
            }
            long dis = tm - System.currentTimeMillis();
            if (dis > 0L) {
                return dis;
            }
            this.hashMap.remove(key);
            it.remove();
            return 0L;
        }
        return 0L;
    }

    public V put(K key, V value, long milliseconds) {
        if (value == null) {
            return null;
        }
        if (milliseconds > 0L) {
            this.timeMap.put(key, System.currentTimeMillis() + milliseconds);
        } else {
            if (milliseconds == 0L) {
                this.remove_(key);
                return null;
            }
            this.timeMap.put(key, this.long_minus_1);
        }
        return this.hashMap.put(key, value);
    }

    private int checkMap() {
        Iterator<Map.Entry<K, Long>> it = this.timeMap.entrySet().iterator();
        int len = 0;
        while (it.hasNext()) {
            Map.Entry<K, Long> entry = it.next();
            long tm = entry.getValue();
            if (tm > 0L && tm - System.currentTimeMillis() <= 0L) {
                this.hashMap.remove(entry.getKey());
                it.remove();
                continue;
            }
            ++len;
        }
        return len;
    }

    @Override
    public int size() {
        return this.checkMap();
    }

    @Override
    public boolean isEmpty() {
        return this.checkMap() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.timeMap.containsKey(key)) {
            long left = this.pttl_(key);
            return left > 0L || left == -1L;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkMap();
        return this.hashMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (this.containsKey(key)) {
            return this.hashMap.get(key);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            return null;
        }
        this.timeMap.put(key, this.long_minus_1);
        return this.hashMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.timeMap.containsKey(key)) {
            return this.remove_(key);
        }
        return null;
    }

    private V remove_(K key) {
        Iterator<Map.Entry<K, Long>> it = this.timeMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, Long> entry = it.next();
            if (!entry.getKey().equals(key)) continue;
            long tm = entry.getValue();
            it.remove();
            if (tm < 0L || tm - System.currentTimeMillis() > 0L) {
                return this.hashMap.remove(key);
            }
            this.hashMap.remove(key);
            return null;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K st : m.keySet()) {
            this.timeMap.put(st, this.long_minus_1);
        }
        this.hashMap.putAll(m);
    }

    @Override
    public void clear() {
        this.timeMap.clear();
        this.hashMap.clear();
    }

    @Override
    public Set<K> keySet() {
        this.checkMap();
        return this.hashMap.keySet();
    }

    @Override
    public Collection<V> values() {
        this.checkMap();
        return this.hashMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.checkMap();
        return this.hashMap.entrySet();
    }
}

