/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.cache.support;

import com.gw.base.cache.GiTtlCache;
import com.gw.base.cache.support.GwTtlMap;
import java.util.concurrent.Callable;

public class GwTtlMapCache
implements GiTtlCache {
    protected static GwTtlMap<Object, Object> cacheMap = new GwTtlMap();
    private String name;

    public GwTtlMapCache() {
        this.name = this.getClass().getName();
    }

    public GwTtlMapCache(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getNativeCache() {
        return cacheMap;
    }

    @Override
    public String getString(Object key) {
        return (String)cacheMap.get(key);
    }

    @Override
    public Object getObject(Object key) {
        return cacheMap.get(key);
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        return (T)cacheMap.get(key);
    }

    @Override
    public <T> T get(Object key, Callable<T> valueLoader) {
        return (T)cacheMap.get(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.put(key, value, -1L);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        if (cacheMap.containsKey(key)) {
            return cacheMap.get(key);
        }
        this.put(key, value);
        return value;
    }

    @Override
    public void evict(Object key) {
        cacheMap.remove(key);
    }

    @Override
    public void clear() {
        cacheMap.clear();
    }

    @Override
    public void put(Object key, Object value, long ttl) {
        cacheMap.put(key, value, ttl);
    }

    @Override
    public long pttl(Object key) {
        return cacheMap.pttl(key);
    }
}

